<?php

declare(strict_types=1);

namespace Stream\Domain\Model;

readonly class TimeDetails
{
    public function __construct(
        private \DateTime $targetTime,
        private \DateTime $now,
        private \DateTime $oneHourAgo,
        private \DateTime $yesterday,
    ) {
    }

    public function getTargetTime(): \DateTime
    {
        return $this->targetTime;
    }

    public function getNow(): \DateTime
    {
        return $this->now;
    }

    public function getOneHourAgo(): \DateTime
    {
        return $this->oneHourAgo;
    }

    public function getYesterday(): \DateTime
    {
        return $this->yesterday;
    }
}
