<?php

declare(strict_types=1);

namespace Stream\Domain\Model;

readonly class AudioChunk
{
    public function __construct(
        private string $audioContent,
        private string $audioFileName,
        private int $startByte,
        private int $endByte,
        private int $totalFileSize,
    ) {
    }

    public function getAudioContent(): string
    {
        return $this->audioContent;
    }

    public function getAudioFileName(): string
    {
        return $this->audioFileName;
    }

    public function getStartByte(): int
    {
        return $this->startByte;
    }

    public function getEndByte(): int
    {
        return $this->endByte;
    }

    public function getTotalFileSize(): int
    {
        return $this->totalFileSize;
    }
}
