<?php

namespace Storage\Doctrine\Entity\Traits;

use Carbon\Carbon;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Custom implementation of Gedmo's TimestampableEntity to be more flexible with returns types and PHP docs.
 */
trait TimestampableEntityTrait
{
    /**
     * @var Carbon
     */
    #[
        Gedmo\Timestampable(on: 'create'),
        ORM\Column(type: Types::DATETIME_MUTABLE)
    ]
    protected $createdAt;

    /**
     * @var Carbon
     */
    #[
        Gedmo\Timestampable(on: 'update'),
        ORM\Column(type: Types::DATETIME_MUTABLE)
    ]
    protected $updatedAt;

    public function setCreatedAt(Carbon $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getCreatedAt(): Carbon
    {
        return $this->createdAt;
    }

    public function setUpdatedAt(Carbon $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getUpdatedAt(): Carbon
    {
        return $this->updatedAt;
    }
}
