<?php

namespace Storage\Doctrine\Entity\Traits;

use Carbon\Carbon;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

/**
 * Custom implementation of Gedmo's SoftDeletableEntity to be more flexible with return types and PHP docs.
 */
trait SoftDeletableEntityTrait
{
    /**
     * @var Carbon|null
     */
    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    protected $deletedAt;

    public function setDeletedAt(?Carbon $deletedAt): self
    {
        $this->deletedAt = $deletedAt;

        return $this;
    }

    public function getDeletedAt(): ?Carbon
    {
        return $this->deletedAt;
    }

    public function isDeleted(): bool
    {
        return $this->deletedAt !== null;
    }

    public function restore(): self
    {
        $this->setDeletedAt(null);

        return $this;
    }
}
