<?php

declare(strict_types=1);

namespace Core\General\Result;

class Set
{
    /**
     * @param mixed[] $results
     */
    public function __construct(
        protected readonly int $totalResults,
        private readonly array $results)
    {
    }

    public function getTotalResults(): int
    {
        return $this->totalResults;
    }

    /**
     * @return mixed[]
     */
    public function getResults(): array
    {
        return $this->results;
    }
}
