<?php

declare(strict_types=1);

namespace Core\General\Pagination\ValueObject;

use Core\General\Result\Set;

class PaginatedSet extends Set
{
    public function __construct(
        array $results,
        int $totalResults,
        private readonly ?int $limit,
        private readonly int $offset,
    ) {
        parent::__construct($totalResults, $results);
    }

    public function getLimit(): ?int
    {
        return $this->limit;
    }

    public function getOffset(): int
    {
        return $this->offset;
    }

    public function getPage(): int
    {
        return (int) floor($this->offset / $this->limit) + 1;
    }

    public function getPerPage(): ?int
    {
        return $this->limit;
    }

    public function getTotalPages(): int
    {
        return (int) ceil($this->totalResults / $this->limit);
    }
}
