<?php

declare(strict_types=1);

namespace Core\General\Helper;

class RegexHelper
{
    public const EMPTY_EXPRESSION = '//';
    public const POSITIVE_DECIMAL_NUMBER = '^\d+([\.\,]\d+)?$';
    public const ONLY_DIGITS = '^\d+$';
    public const DECIMAL_NUMBER = '^[-+]?[0-9]*[.,]?[0-9]+$';
    public const OCLOCK = '\d{1,2}:\d{1,2}';
    public const DATE = '^\d\d?\.\d\d?\.\d\d\d\d\.$';
    public const DATE_TIME = '^\d{4}-\d{2}-\d{2}( \d{2}:\d{2}:\d{2})?$';
    public const ONLY_DECIMAL_NUMBER = '[^0-9.,]';
    public const UUID = '\A[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}\z';
    public const EMAIL_IGNORED_PARTS = '\.|\+.*(?=@)'; // Matches dots and `+<anything>`
    public const CAMEL_CASE_STRING = '^[a-z]+[a-zA-Z0-9]*([a-zA-Z0-9]+)*$';
    public const KEBAB_CASE_STRING = '^[a-z]+[a-z0-9]*(-[a-z0-9]+)*$';
    public const SNAKE_CASE_STRING = '^[a-z]+[a-z0-9]*(_[a-z0-9]+)*$';

    public static function getOnlyDigitsExpression(): string
    {
        return \sprintf('/%s/', self::ONLY_DIGITS);
    }

    public static function getDecimalNumberExpression(): string
    {
        return \sprintf('/%s/', self::DECIMAL_NUMBER);
    }

    public static function getPositiveDecimalNumberExpression(): string
    {
        return \sprintf('/%s/', self::POSITIVE_DECIMAL_NUMBER);
    }

    public static function getDateExpression(): string
    {
        return \sprintf('/%s/', self::DATE);
    }

    public static function getOClockExpression(): string
    {
        return \sprintf('/%s/', self::OCLOCK);
    }

    public static function getOnlyDecimalNumberExpression(): string
    {
        return \sprintf('/%s/', self::ONLY_DECIMAL_NUMBER);
    }

    public static function getDateTimeExpression(): string
    {
        return \sprintf('/%s/', self::DATE_TIME);
    }

    public static function getUuidExpression(): string
    {
        return \sprintf('/%s/', self::UUID);
    }

    public static function getEmailIgnoredPartsExpression(string $email): string
    {
        if (str_contains($email, '@gmail')) {
            return self::EMPTY_EXPRESSION;
        }

        return \sprintf('/%s/', self::EMAIL_IGNORED_PARTS);
    }

    public static function getCamelCaseExpression(): string
    {
        return \sprintf('/%s/', self::CAMEL_CASE_STRING);
    }

    public static function getKebabCaseExpression(): string
    {
        return \sprintf('/%s/', self::KEBAB_CASE_STRING);
    }

    public static function getSnakeCaseExpression(): string
    {
        return \sprintf('/%s/', self::SNAKE_CASE_STRING);
    }
}
