<?php

declare(strict_types=1);

namespace Core\General\Exception;

final class RuntimeException extends \Exception
{
    private function __construct(string $message = '', int $code = 500)
    {
        parent::__construct($message, $code);
    }

    public static function becauseUnexpectedErrorOccurred(string $message = 'exception.unexpected', int $code = 500): self
    {
        return new self($message, $code);
    }
}
