<?php

declare(strict_types=1);

namespace Core\General\Enum;

abstract class BaseEnum
{
    /** @var string[] */
    protected static array $labels = [];

    /**
     * @return string[]
     */
    public static function getConstants(): array
    {
        $oClass = new \ReflectionClass(static::class);

        return $oClass->getConstants();
    }

    public static function getLabelById(string $id): ?string
    {
        if (isset(static::$labels[$id])) {
            return static::$labels[$id];
        }

        return null;
    }

    /**
     * @return array<int|string, mixed>
     */
    public static function getOptions(bool $objects = false): array
    {
        $constants = self::getConstants();
        $keys = array_values($constants);

        $return = [];

        foreach ($keys as $key) {
            $value = self::getLabelById($key);

            if ($objects) {
                $return[] = ['id' => $key, 'label' => $value];
                continue;
            }

            $return[$key] = $value;
        }

        return $return;
    }

    public static function contains(mixed $value): bool
    {
        $values = self::getConstants();

        return \in_array($value, $values);
    }

    /**
     * @return string[]
     */
    public static function getLabels(): array
    {
        return static::$labels;
    }

    public static function getConstantsAsString(): string
    {
        $oClass = new \ReflectionClass(static::class);

        return implode(', ', $oClass->getConstants());
    }
}
