<?php

declare(strict_types=1);

namespace Core\General\Database\Query;

class BindableExpression
{
    /**
     * @param array<string, mixed> $params
     */
    public function __construct(private string $query = '', private array $params = [])
    {
    }

    public function addQuery(string $query): self
    {
        $this->query = \sprintf('%s %s', $this->query, $query);

        return $this;
    }

    public function getQuery(): string
    {
        return $this->query;
    }

    /**
     * @return array<string, mixed>
     */
    public function getParams(): array
    {
        return $this->params;
    }

    /**
     * @param array<string, mixed> $params
     */
    public function addParams(array $params): self
    {
        $this->params = array_merge($this->params, $params);

        return $this;
    }
}
