<?php

declare(strict_types=1);

namespace Core\Framework\Message\Exception;

final class MessageException extends \Exception
{
    private function __construct(string $message = '', int $code = 500)
    {
        parent::__construct($message, $code);
    }

    public static function becauseUnexpectedErrorOccurred(string $message): self
    {
        return new self($message);
    }
}
