<?php

declare(strict_types=1);

namespace Core\Framework\Event;

use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Wrapper around Symfony's event dispatcher
 */
readonly class EventBus
{
    public function __construct(
        private EventDispatcherInterface $eventDispatcher,
    ) {
    }

    public function dispatch(Event $event): void
    {
        $this->eventDispatcher->dispatch($event, $event::class);
    }
}
