<?php

declare(strict_types=1);

namespace Core\Framework\CompilerPass;

use Core\Framework\Command\CommandBus;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class CommandBusCompilerPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition(CommandBus::class)) {
            return;
        }

        $definition = $container->getDefinition(CommandBus::class);
        foreach ($container->findTaggedServiceIds('command_bus_map') as $id => $attributes) {
            $definition->addMethodCall('registerCommandMap', [new Reference($id)]);
        }
    }
}
